(function ($) {
    // Wait for the document to be ready
    $(document).ready(function () {
        // Add event listener for when the Quick Edit button is clicked
        $('.editinline').on('click', function () {
            // Get the post ID from the containing row
            const postId = $(this).closest('tr').attr('id').replace('post-', '');

            // Get the event status from the hidden data
            const eventStatus = $('#inline_' + postId + ' .event_status').text();

            // Get the tour ID from the hidden data
            const eventTour = $('#inline_' + postId + ' .event_tour').text();

            // Set the value in the Quick Edit form's status dropdown
            $('select[name="event_status"]').val(eventStatus);

            // Set the value in the Quick Edit form's tour dropdown
            $('select[name="event_tour"]').val(eventTour);
        });

        // Handle bulk edit
        $('body').on('click', '#doaction, #doaction2', function (e) {
            const action = $(this).siblings('select').val();
            if (action === 'edit') {
                // Small delay to ensure bulk edit form is rendered
                setTimeout(function () {
                    // Reset tour dropdown to "No change" for bulk edit
                    $('.bulk-edit-row select[name="event_tour"]').val('');
                }, 100);
            }
        });
    });
})(jQuery);