<?php
/**
 * Handle ACF field group registration and JSON sync
 */

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

class Vizou_Events_Field_Groups {
    public static function register() {
        // Add local JSON load point
        add_filter('acf/settings/load_json', array(__CLASS__, 'add_json_load_point'));
        
        // Register field groups if they don't exist
        self::register_field_groups();
    }
    
    public static function add_json_load_point($paths) {
        $paths[] = plugin_dir_path(dirname(__FILE__)) . 'acf-json/groups';
        return $paths;
    }
    
    private static function register_field_groups() {
        if (function_exists('acf_add_local_field_group')) {
            // Check if field groups already exist
            $existing_groups = acf_get_field_groups();
            $group_keys = array('group_5cf91ea11e592', 'group_6728056110545');
            
            foreach ($group_keys as $key) {
                $exists = false;
                foreach ($existing_groups as $group) {
                    if ($group['key'] === $key) {
                        $exists = true;
                        break;
                    }
                }
                
                if (!$exists) {
                    // Load and register from JSON
                    $json_file = plugin_dir_path(dirname(__FILE__)) . 'acf-json/groups/event-fields.json';
                    if (file_exists($json_file)) {
                        $json = json_decode(file_get_contents($json_file), true);
                        if (is_array($json)) {
                            foreach ($json as $field_group) {
                                acf_add_local_field_group($field_group);
                            }
                        }
                    }
                }
            }
        }
    }
}