<?php
/**
 * Help page functionality
 */

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

class Vizou_Events_Help {
    public static function register() {
        add_action('admin_menu', [__CLASS__, 'add_help_page']);
    }

    public static function add_help_page() {
        add_submenu_page(
            'edit.php?post_type=event',
            esc_html__('Events Help & FAQ', 'vizou-events-manager'),
            esc_html__('Help', 'vizou-events-manager'),
            'edit_posts',
            'vizou-events-help',
            [__CLASS__, 'render_help_page']
        );
    }

    public static function render_help_page() {
        if (!current_user_can('edit_posts')) {
            wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'vizou-events-manager'));
        }
        ?>
        <div class="wrap">
            <h2><?php esc_html_e('Vizou Events Manager help', 'vizou-events-manager'); ?></h2>
                <p><?php 
                    $url = 'https://explicable.ca/category/plugins/vizou-events-manager/';
                    $before_link = __('This plugin is not available from the WordPress repository. Visit the ', 'vizou-events-manager');
                    $link_text = __('plugin docs page', 'vizou-events-manager');
                    $after_link = __(' for more information and any available downloads, including updates, import/export samples, stylesheet and template files.', 'vizou-events-manager');
                    
                    echo esc_html($before_link);
                    echo '<a href="' . esc_url($url) . '" target="_blank">' . esc_html($link_text) . '</a>';
                    echo esc_html($after_link);
                ?>
                </p>
            
            <h3><?php esc_html_e('How to use the shortcode', 'vizou-events-manager'); ?></h3>
                <p>
                    <code>[vizou-events]</code> <?php esc_html_e('is the shortcode. By default, it gets all active, upcoming events in ascending order.', 'vizou-events-manager'); ?>
                </p>
                
                <p><?php esc_html_e('Use it with the following parameters to get a variety of data:', 'vizou-events-manager'); ?></p>
                
                <ul>
                    <li><strong><?php esc_html_e('show', 'vizou-events-manager'); ?></strong> - <?php esc_html_e('"upcoming" (default), "past", or "all"', 'vizou-events-manager'); ?></li>
                    <li><strong><?php esc_html_e('year', 'vizou-events-manager'); ?></strong> - <?php esc_html_e('YYYY to filter by year', 'vizou-events-manager'); ?></li>
                    <li><strong><?php esc_html_e('order', 'vizou-events-manager'); ?></strong> - <?php esc_html_e('"asc" (default, nearest date from today first) or "desc" (latest date first)', 'vizou-events-manager'); ?></li>
                    <li><strong><?php esc_html_e('artist', 'vizou-events-manager'); ?></strong> - <?php esc_html_e('by ID (see Events/Artists)', 'vizou-events-manager'); ?></li>
                    <li><strong><?php esc_html_e('tour', 'vizou-events-manager'); ?></strong> - <?php esc_html_e('by ID (see Events/Tours)', 'vizou-events-manager'); ?></li>
                    <li><strong><?php esc_html_e('exclude_tour', 'vizou-events-manager'); ?></strong> - <?php esc_html_e('exclude tour by ID (see Events/Tours)', 'vizou-events-manager'); ?></li>
                    <li><strong><?php esc_html_e('limit', 'vizou-events-manager'); ?></strong> - <?php esc_html_e('number of events to show (-1 for all)', 'vizou-events-manager'); ?></li>
                </ul>

            <h3><?php esc_html_e('Shortcode variation examples', 'vizou-events-manager'); ?></h3>
            
                <p><code>[vizou-events show="past" year="2020" order="desc"]</code></p>
                <p><code>[vizou-events show="all" tour="123"]</code></p>
                <p><code>[vizou-events show="upcoming" artist="25" order="asc"]</code></p>
                <p><code>[vizou-events show="all" tour="3, 20, 44" order="asc"]</code></p>
                <p><code>[vizou-events show="upcoming" exclude_tour="15"]</code></p>
                <p><code>[vizou-events show="upcoming" exclude_tour="15, 20"]</code></p>

            <h3><?php esc_html_e('Shortcode recipes', 'vizou-events-manager'); ?></h3>
            
            <h4><?php esc_html_e('Upcoming shows', 'vizou-events-manager'); ?></h4>
                <p><?php esc_html_e('Ascending (next up) order. This is the default. If the artist or venues have an associated url, it will automatically be linked. If there is a ticket url, a ticket link will be displayed.', 'vizou-events-manager'); ?></p>
                <p><code>[vizou-events]</code></p>

            <h4><?php esc_html_e('Past shows for a year', 'vizou-events-manager'); ?></h4>
                <p><?php esc_html_e('For the year 2024, in descending order (the latest date at the top).', 'vizou-events-manager'); ?></p>
                <p><code>[vizou-events show="past" year="2024" order="desc"]</code></p>

            <h4><?php esc_html_e('Recent shows', 'vizou-events-manager'); ?></h4>
                <p><?php esc_html_e('In descending order (the latest date at the top), limited to 5 shows.', 'vizou-events-manager'); ?></p>
                <p><code>[vizou-events show="past" limit="5" order="desc"]</code></p>

            <h4><?php esc_html_e('Tours', 'vizou-events-manager'); ?></h4>
                <p><?php esc_html_e('Show all upcoming dates for a specific tour (or tours) by id (Events/Tours, grab the ID), showing the next up on top. To show multiple tours, separate IDs with commas.', 'vizou-events-manager'); ?></p>
                <p><code>[vizou-events show="all" tour="267" order="asc"]</code></p>

                <h4><?php esc_html_e('Excluding specific tours', 'vizou-events-manager'); ?></h4>
                <p><?php esc_html_e('Show upcoming events but exclude specific tours.', 'vizou-events-manager'); ?></p>

                <p><code>[vizou-events show="upcoming" exclude_tour="15"]</code></p>
                <p><?php esc_html_e('To exclude multiple tours, separate IDs with commas:', 'vizou-events-manager'); ?></p>
                <p><code>[vizou-events show="upcoming" exclude_tour="15, 20"]</code></p>

                <h4><?php esc_html_e('Request a show', 'vizou-events-manager'); ?></h4>
                <p><?php esc_html_e('Add this shortcode anywhere to display your custom "Request a show" text and link.', 'vizou-events-manager'); ?></p>
                <p><code>[vizou-events requestshow="true"]</code></p>

        </div>
    <?php
    }
}