<?php
/**
 * Register custom post types
 */

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

class Vizou_Events_Post_Types {
    public static function register() {
        self::register_event_post_type();
    }
    
    private static function register_event_post_type() {
        $labels = array(
            'name'               => 'Events',
            'singular_name'      => 'Event',
            'menu_name'          => 'Events',
            'add_new'           => 'Add New Event',
            'add_new_item'      => 'Add New Event',
            'edit_item'         => 'Edit Event',
            'view_item'         => 'View Event',
            'all_items'         => 'All Events',
            'search_items'      => 'Search Events',
            'not_found'         => 'No events found',
            'not_found_in_trash'=> 'No events found in Trash'
        );
        
        $args = array(
            'labels'              => $labels,
            'public'              => true,
            'publicly_queryable'  => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'rewrite'            => array('slug' => 'event'),
            'capability_type'    => 'post',
            'has_archive'        => false,
            'hierarchical'       => false,
            'menu_position'      => null,
            'menu_icon'          => 'dashicons-calendar-alt',
            'taxonomies'         => array('venue', 'artist', 'tour'),
            'supports'           => array('title', 'editor', 'thumbnail'),
            'show_in_rest'       => true
        );
        
        register_post_type('event', $args);
    }
}