<?php
/**
 * Template: Single Event Template
 *
 * This template displays a single event on its dedicated page.
 * To customize, copy this file to your-theme/single-event.php or your-theme/vizou-events/vizou-single-event.php
 * 
 * This template includes the WordPress header and footer and handles the main query.
 *
 * @package Vizou_Events_Manager
 * @since 0.1.12
 */

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

get_header(); 
?>
	
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

        <div class="single-event-wrapper">

            <?php
            // Determine classes for the event
            $classes = array('event');
            
            // Check if this is a past event
            if (function_exists('vizou_is_past_event') && vizou_is_past_event()) {
                $classes[] = 'event-past';
            } else {
                // Direct implementation as fallback
                $event_date = get_field('event_start');
                if ($event_date) {
                    try {
                        // First try d/m/Y format (ACF default)
                        $event_datetime = DateTime::createFromFormat('d/m/Y', $event_date);
                        if (!$event_datetime) {
                            // If that fails, try Y-m-d format
                            $event_datetime = DateTime::createFromFormat('Y-m-d', $event_date);
                        }
                        
                        if ($event_datetime) {
                            // Set time to end of day for consistent comparison
                            $event_datetime->setTime(0, 0, 0);
                            
                            $current_datetime = new DateTime();
                            $current_datetime->setTime(0, 0, 0);
                            
                            if ($event_datetime < $current_datetime) {
                                $classes[] = 'event-past';
                            }
                        }
                    } catch (Exception $e) {
                        // Fail silently
                    }
                }
            }
            
            // Check if this is a cancelled event
            if (function_exists('vizou_is_cancelled_event') && vizou_is_cancelled_event()) {
                $classes[] = 'event-cancelled';
            } else {
                // Direct implementation as fallback
                $event_status = get_field('event_status');
                if ($event_status && strcasecmp(trim($event_status), 'cancelled') === 0) {
                    $classes[] = 'event-cancelled';
                }
            }
            ?>

            <!-- BEGIN EVENT -->
            <article class="<?php echo esc_attr(implode(' ', array_map('sanitize_html_class', $classes))); ?>">

                <!-- TICKETS OR STATUS -->
                <?php 
                // Get event status
                $event_status = get_field('event_status');
                $ticket_url = get_field('event_ticket_url');
                
                // Show status badge if not active, otherwise show ticket button if URL exists
                if ($event_status && strtolower(trim($event_status)) !== 'active') {
                    // Display status as a badge
                    $status_label = Vizou_Events_Settings::get_status_label($event_status);
                    echo '<span class="event-status button">' . esc_html($status_label) . '</span>';
                } elseif ($ticket_url) {
                    // Display ticket button
                    vizou_event_ticket_button();
                }
                ?>

                <!-- TITLE (VENUE, ARTIST) -->
                <h1 class="event-title">
                    <?php 
                    // Display format depends on the setting
                    $display_format = Vizou_Events_Settings::get_option('display_format');
                    
                    // Check if artist exists
                    $has_artist = false;
                    $artist_terms = get_the_terms(get_the_ID(), 'artist');
                    if (!empty($artist_terms) && !is_wp_error($artist_terms)) {
                        $has_artist = true;
                    }
                    
                    if ($display_format === 'artist_first') {
                        // Artist first
                        if ($has_artist) {
                            echo '<span class="event-artist artist-first">';
                            vizou_event_artist();
                            echo '</span>';
                            echo '<span class="event-venue">';
                            vizou_event_venue();
                            echo '</span>';
                        } else {
                            // Only venue if no artist
                            echo '<span class="event-venue">';
                            vizou_event_venue();
                            echo '</span>';
                        }
                    } else {
                            // Venue first (default)
                            echo '<span class="event-venue venue-first">';
                            vizou_event_venue();
                            echo '</span>';
                        if ($has_artist) {
                            echo '<span class="event-artist">';
                            vizou_event_artist();
                            echo '</span>';
                        }
                    }
                    ?>
                </h1>

                <!-- DATE, TIME, LOCATION -->
                <div class="event-date">
                    <?php 
                    // Get both dates to determine if this is a multi-day event
                    $start_date = vizou_event_date(null, false);
                    $end_date = vizou_event_end_date(null, false);
                    
                    // Output date or date range appropriately
                    echo '<span class="event-start-date">' . esc_html($start_date) . '</span>';
                    
                    if (!empty($end_date)) {
                        echo ' - <span class="event-end-date">' . esc_html($end_date) . '</span>';
                    }
                    ?>

                    <?php if (vizou_event_time(null, false)): ?>
                        <span class="event-time"> - <?php vizou_event_time(); ?></span>
                    <?php endif; ?>

                </div>

                <?php if (vizou_event_venue_city(null, false)): ?>
                    <div class="event-address">
                        <?php if (vizou_event_venue_street(null, false)): ?>
                            <span class="event-street"><?php vizou_event_venue_street(); ?>, </span>
                        <?php endif; ?>
                        
                        <?php if (vizou_event_venue_city(null, false)): ?>
                            <span class="event-city"><?php vizou_event_venue_city(); ?>, </span>
                        <?php endif; ?>
                        
                        <?php if (vizou_event_venue_province(null, false)): ?><span class="event-province"><?php vizou_event_venue_province(); ?></span>
                        <?php endif; ?>
                        
                        <?php if (vizou_event_venue_country(null, false)): ?>
                            <span class="event-country"> (<?php vizou_event_venue_country(); ?>)</span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <!-- NOTES -->
                <?php if (vizou_event_notes(null, false)): ?>
                    <?php vizou_event_notes(); ?>
                <?php endif; ?>

                <!-- THUMBNAIL -->
                <?php if (has_post_thumbnail()): ?>
                    <?php the_post_thumbnail('large', array(
                        'class' => 'event-thumb',
                        'loading' => 'lazy',
                        'alt' => get_the_title()
                    )); ?>
                <?php endif; ?>
                
                <!-- EDIT EVENT LINK -->
                <?php edit_post_link(esc_html__('Edit', 'vizou-events-manager'), '', '');?>

            </article>
				
        </div>
                    
    <?php endwhile; endif; ?>
        
<?php get_footer(); ?>