<?php
if (!defined('WP_UNINSTALL_PLUGIN')) {
    die;
}

$options = get_option('vizou_events_options');
if (isset($options['delete_on_uninstall']) && $options['delete_on_uninstall']) {
    // Delete post type entries
    $events = get_posts([
        'post_type' => 'event',
        'numberposts' => -1,
        'fields' => 'ids' // More efficient, only get IDs
    ]);
    
    foreach ($events as $event_id) {
        wp_delete_post($event_id, true);
    }
    
    // Delete taxonomies and their meta
    $taxonomies = ['venue', 'artist', 'tour'];
    foreach ($taxonomies as $tax) {
        $terms = get_terms([
            'taxonomy' => $tax,
            'hide_empty' => false,
            'fields' => 'ids' // More efficient, only get IDs
        ]);
        
        if (!is_wp_error($terms)) {
            foreach ($terms as $term_id) {
                // Delete term meta before deleting term
                delete_term_meta($term_id, 'event_url');
                if ($tax === 'artist') {
                    delete_term_meta($term_id, 'event_artist_url');
                }
                wp_delete_term($term_id, $tax);
            }
        }
    }
    
    // Handle ACF fields deletion using proper WordPress functions
    $acf_posts = get_posts([
        'post_type' => ['acf-field', 'acf-field-group'],
        'posts_per_page' => -1,
        'post_status' => 'any',
        'fields' => 'ids',
        'meta_query' => [
            'relation' => 'OR',
            [
                'key' => 'field_type',
                'value' => 'field_%',
                'compare' => 'LIKE'
            ],
            [
                'key' => 'field_type',
                'value' => 'group_event_%',
                'compare' => 'LIKE'
            ]
        ]
    ]);
    
    // Use WordPress cache API for bulk operations
    wp_cache_delete_multiple($acf_posts, 'posts');
    
    foreach ($acf_posts as $post_id) {
        // Clean up post meta
        $post_meta_keys = get_post_custom_keys($post_id);
        if ($post_meta_keys) {
            foreach ($post_meta_keys as $meta_key) {
                delete_post_meta($post_id, $meta_key);
            }
        }
        
        // Delete the post itself
        wp_delete_post($post_id, true);
    }
    
    // Clean up options
    delete_option('vizou_events_options');
    
    // Clear any remaining caches
    wp_cache_flush();
}